<?php
/*
	#	Webpay Payment module callback for Sendroid Ultimate
	#	location: gateway/webpay/callback.php
	#	Developed by: Ynet Interactive
	#	Special thanks: Mr. White

*/
define('ENVIRONMENT', 'production');
ob_start();
session_start();
$URL = 'dashboard';
if (defined('ENVIRONMENT'))
{
	switch (ENVIRONMENT)
	{
		case 'development':
			error_reporting(E_ALL);
		break;
	
		case 'testing':
		case 'production':
			error_reporting(0);
		break;

		default:
			exit('The application environment is not set correctly.');
	}
}
$system_path = '../../system';
$application_folder = 'hooks';
$module_folder = 'modules';
	// Set the current directory correctly for CLI requests
	if (defined('STDIN'))
	{
		chdir(dirname(__FILE__));
	}

	if (realpath($system_path) !== FALSE)
	{
		$system_path = realpath($system_path).'/';
	}

	// ensure there's a trailing slash
	$system_path = rtrim($system_path, '/').'/';
	// Is the system path correct?
	if ( ! is_dir($system_path))
	{
		exit("Your system folder path does not appear to be set correctly. Please open the following file and correct this: ".pathinfo(__FILE__, PATHINFO_BASENAME));
	}
	// The name of THIS file
	define('SELF', pathinfo(__FILE__, PATHINFO_BASENAME));
	// The PHP file extension
	// this global constant is deprecated.
	define('EXT', '.php');
	// Path to the system folder
	define('BASEPATH', str_replace("\\", "/", $system_path));
	// Path to the front controller (this file)
	define('FCPATH', str_replace(SELF, '', __FILE__));
	// Name of the "system folder"
	define('SYSDIR', trim(strrchr(trim(BASEPATH, '/'), '/'), '/'));

	// The path to the "application" folder
	if (is_dir($application_folder))
	{
		define('APPPATH', $application_folder.'/');
		define('MODPATH', $module_folder.'/');
	}
	else
	{
		if ( ! is_dir(BASEPATH.$application_folder.'/'))
		{
			exit("Your application folder path does not appear to be set correctly. Please open the following file and correct this: ".SELF);
		}

		define('APPPATH', BASEPATH.$application_folder.'/');
		define('MODPATH', BASEPATH.$module_folder.'/');
	}
define('COR', BASEPATH.'core/');	
define('LIB', BASEPATH.'libraries/');	
define('HELP', BASEPATH.'helpers/');	
require_once '../../root.php';
require_once BASEPATH.'core/Config.php';
foreach (glob(COR."/*.php") as $filename) { include $filename; }
foreach (glob(HELP."/*.php") as $filename) { include $filename; }
foreach (glob(LIB."/*.php") as $filename) { include $filename; }
$Config = new CI_Config();
setTimeZone();
require_once BASEPATH.'lang/'.setLang(1);
$is_valid = 0;
$response = $LANG['Payment verification failed'];
//Load saved transaction from Session is available
$Transaction_ref = $_SESSION['reference'];
$Payment_gateway = $_SESSION['gateway'];
$user_id = $_SESSION['tx_user'];
if(!isset($_SESSION['reference']) || empty($_SESSION['reference'])) {
	//Get reference from query strings
	$Transaction_ref = mysqli_real_escape_string($server,$_REQUEST['tx_reference']); 
	$result = mysqli_query($server,"SELECT * FROM transactions WHERE transaction_reference = '$Transaction_ref'"); 
	$row = mysqli_fetch_assoc($result);
	$Transaction_id = $row['id'];
	$user_id = $row['customer_id'];
	$amount = $row['cost'];
	$Payment_gateway = $row['method'];
}
if($Transaction_ref!="") {
	$_SESSION['reference'] = $Transaction_ref;
	$comments = 'Your payment was not successful';
	$is_valid = 0;
	$interswitch_product_id = trim(paymentGatewayData($Payment_gateway,'param1'));	//This is saved in param1 column
	$interswitch_mac_key = trim(paymentGatewayData($Payment_gateway,'param2'));	//This is saved in param2 column	
	$transaction_reference = $Transaction_ref;
	$interswitch_url='https://webpay.interswitchng.com/paydirect/api/v1/gettransaction.json';
	
	$currency = paymentGatewayData($Payment_gateway,'currency_id');
	$user_currency = userData($user_id,'currency_id');	
	$amount_converted = $amount*currencyRate($currency);			//Convert amount to charge to gateway's currency
	if($user_currency==$currency) {
		$amount_converted = $amount;								// No conversion needed
	}
	$gtpay_amount = round($amount*100);
				
	$hash = strtoupper(hash("sha512",$interswitch_product_id.$transaction_reference.$interswitch_mac_key));
	$url="$interswitch_url?productid=$interswitch_product_id&transactionreference=$transaction_reference&amount=$gtpay_amount";
	
	$ch = curl_init();
	curl_setopt($ch,CURLOPT_HTTPHEADER,array("Hash: $hash"));
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);			
	curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_URL, $url);
				
	$response = curl_exec($ch);
	$returnCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	if($returnCode != 200) { 
		$response=curl_error($ch);
	}
	curl_close($ch);	
	$json=null;
				
	if($returnCode == 200) {
		$json = json_decode($response,true);
	} else { 
		$response="HTTP Error $returnCode: $response. ";
	}

	if(!empty($json)) { 			
		$respinseCode = $json['ResponseCode'];	
		$desc = $json['ResponseDescription'];
		$amount = $json['Amount'];
		if($respinseCode == '00') {
			$is_valid = 1;
			$comments = $json['ResponseDescription'];
		} else {
			$is_valid = -1;
			$comments = 'Paymenr Failed '.$desc;
		}
	} else { 
		$is_valid = -1;
		$comments = 'Paymenr Failed '.$response;
	}
}

if($is_valid < 1) {
	$_SESSION['message'] = $comments;
	mysqli_query($server,"UPDATE transactions SET status = 'Failed' WHERE transaction_reference = '$Transaction_ref' LIMIT 1");
	mysqli_query($server,"UPDATE transactions SET gateway_response = '$response' WHERE transaction_reference = '$Transaction_ref' LIMIT 1");
	logEvent($user_id,'Transaction: '.$Transaction_ref.' failed');		
	header('location: ../../fund?confirm=0');		//pay attention to the path
	exit();
} else {
	processTransaction($Transaction_ref);
	header('location: ../../fund?confirm=1');		//pay attention to the path 
	exit();
}
?>
