<?php
/*
	#	Stripe Payment module callback for Sendroid Ultimate
	#	location: gateway/stripe/index.php
	#	Developed by: Ynet Interactive
	#	Special thanks: Mr. White

*/
define('ENVIRONMENT', 'production');
ob_start();
session_start();
$URL = 'dashboard';

if (defined('ENVIRONMENT'))
{
	switch (ENVIRONMENT)
	{
		case 'development':
			error_reporting(E_ALL);
		break;
	
		case 'testing':
		case 'production':
			error_reporting(0);
		break;

		default:
			exit('The application environment is not set correctly.');
	}
}
$system_path = '../../system';
$application_folder = 'hooks';
$module_folder = 'modules';
	// Set the current directory correctly for CLI requests
	if (defined('STDIN'))
	{
		chdir(dirname(__FILE__));
	}

	if (realpath($system_path) !== FALSE)
	{
		$system_path = realpath($system_path).'/';
	}

	// ensure there's a trailing slash
	$system_path = rtrim($system_path, '/').'/';
	// Is the system path correct?
	if ( ! is_dir($system_path))
	{
		exit("Your system folder path does not appear to be set correctly. Please open the following file and correct this: ".pathinfo(__FILE__, PATHINFO_BASENAME));
	}
	// The name of THIS file
	define('SELF', pathinfo(__FILE__, PATHINFO_BASENAME));
	// The PHP file extension
	// this global constant is deprecated.
	define('EXT', '.php');
	// Path to the system folder
	define('BASEPATH', str_replace("\\", "/", $system_path));
	// Path to the front controller (this file)
	define('FCPATH', str_replace(SELF, '', __FILE__));
	// Name of the "system folder"
	define('SYSDIR', trim(strrchr(trim(BASEPATH, '/'), '/'), '/'));

	// The path to the "application" folder
	if (is_dir($application_folder))
	{
		define('APPPATH', $application_folder.'/');
		define('MODPATH', $module_folder.'/');
	}
	else
	{
		if ( ! is_dir(BASEPATH.$application_folder.'/'))
		{
			exit("Your application folder path does not appear to be set correctly. Please open the following file and correct this: ".SELF);
		}

		define('APPPATH', BASEPATH.$application_folder.'/');
		define('MODPATH', BASEPATH.$module_folder.'/');
	}
define('COR', BASEPATH.'core/');	
define('LIB', BASEPATH.'libraries/');	
define('HELP', BASEPATH.'helpers/');	
require_once '../../root.php';
require_once BASEPATH.'core/Config.php';
require_once __DIR__ .'/class/ini.php';
foreach (glob(COR."/*.php") as $filename) { include $filename; }
foreach (glob(HELP."/*.php") as $filename) { include $filename; }
foreach (glob(LIB."/*.php") as $filename) { include $filename; }
$Config = new CI_Config();
setTimeZone();
require_once BASEPATH.'lang/'.setLang(1);
$is_valid = 0;
$response = $LANG['Payment verification failed'];
//Load saved transaction from Session is available
$Transaction_ref = $_SESSION['reference'];
$Payment_gateway = $_SESSION['gateway'];
$user_id = $_SESSION['tx_user'];
if(!isset($_SESSION['reference']) || empty($_SESSION['reference'])) {
	//Get reference from query strings
	$Transaction_ref = mysqli_real_escape_string($server,$_REQUEST['tx_reference']); 
	$result = mysqli_query($server,"SELECT * FROM transactions WHERE transaction_reference = '$Transaction_ref'"); 
	$row = mysqli_fetch_assoc($result);
	$Transaction_id = $row['id'];
	$user_id = $row['customer_id'];
	$Payment_gateway = $row['method'];
}
if($Transaction_ref!="") {
	$_SESSION['reference'] = $Transaction_ref;
	$comments = 'Your payment was not successful';
	//process Stripe
	if ($_POST['stripeToken']) {
	  $transaction_id = $Transaction_ref;
	  $stripe_api_key = trim(paymentGatewayData($Payment_gateway,'param2'));
	  	  
	  \Stripe\Stripe::setApiKey($stripe_api_key);
	  \Stripe\Stripe::setVerifySslCerts(false);
	  $comments = 'Payment validation failed';
	  $is_valid = 0;
	  try {
		if (!isset($_POST['stripeToken']))
		  throw new Exception("The Stripe Token was not generated correctly");
		  \Stripe\Charge::create(array("amount" => $_POST['amount'],
									"currency" => "usd",
									"metadata" => array("Transaction_Refference" => $Transaction_ref, 
														"Firet_Name" => userData($user_id,'first_name'), 
														"Last_Name" => userData($user_id,'last_name')
													),
									"card" => $_POST['stripeToken']));
		$comments = 'Transaction Successful';
		$is_valid = 1;
	  }
	  catch (Exception $e) {
		$error = $e->getMessage();
		$comments = @$error;
		$is_valid = -1;
	  }
	}
}

if($is_valid < 1) {
	$_SESSION['message'] = $comments;
	mysqli_query($server,"UPDATE transactions SET status = 'Failed' WHERE transaction_reference = '$Transaction_ref' LIMIT 1");
	mysqli_query($server,"UPDATE transactions SET gateway_response = '$response' WHERE transaction_reference = '$Transaction_ref' LIMIT 1");
	logEvent($user_id,'Transaction: '.$Transaction_ref.' failed');		
	header('location: ../../fund?confirm=0');		//pay attention to the path
	exit();
} else {
	processTransaction($Transaction_ref);
	header('location: ../../fund?confirm=1');		//pay attention to the path 
	exit();
}
?>
